global files "C:/Users/WB326023/Dropbox/WB/BPEA/BPEA Replication/"
global BPEAraw "$files/dataraw"
global BPEAout "$files/dataout"
global BPEAtemp "$files/temp"
global BPEAplots "$files/plots"

* colour blind friendly colours
global cblue "0 114 178"
global cred "213 94 0"
global corange "230 159 0"
global cyellow "240 228 66"
global cgreen "0 158 115"
global cblack "0 0 0"
global cpurple "204 121 167"
global cskyblue "86 180 233"

global graphsettings graphregion(color(white)) bgcolor(white) ylabel(, grid glcolor(gs15))


// figure 3 - shares
use "$BPEAout/v2_data/v2_fig_trendcounts_factiva.dta", clear
tsset year

foreach v of varlist share_natsec share_resilience { 
	su `v' if year == 2022 , meanonly 
	local name: variable label `v'
	local call `call' text(`r(mean)' 2022 "`name'",  place(r))  	 
} 

twoway 	(tsline share_natsec, lcolor("$cblue")) || ///
		(tsline share_resilience, lcolor("$cpurple")), ///
		`call' ///
	$graphsettings ///
	legend(off) tscale(range(2012 2028)) tlabel(2000(5)2020) ///
	ytitle("Percent of news articles mentioning", size(large)) xtitle("") ///
	title("Panel A", color(black))

graph save "$BPEAout/v2_graphs/vf_fig3_panelA_share.gph", replace
*graph export "$BPEAplots/v2/vf_fig3_panelA_share.pdf", replace
*graph export "$BPEAplots/v2/vf_fig3_panelA_share.png", replace
*graph export "$BPEAplots/v2/vf_fig3_panelA_share.eps", replace
local call

foreach v of varlist share_chinaplusone share_reshoring share_friendshoring  { 
	su `v' if year == 2022 , meanonly 
	local name: variable label `v'
	local call `call' text(`r(mean)' 2022 "`name'",  place(r))  	 
} 

twoway 	(tsline share_chinaplusone, lcolor("$corange")) || ///
		(tsline share_reshoring, lcolor("$cgreen")) || ///
		(tsline share_friendshoring, lcolor("$cyellow")),  ///
		`call' ///
		$graphsettings ///
		legend(off) tscale(range(2012 2028)) tlabel(2000(5)2020) ///
		ytitle("Percent of news articles mentioning", size(large)) xtitle("") ///
		title("Panel B", color(black))

graph save "$BPEAout/v2_graphs/vf_fig3_panelB_share.gph", replace
*graph export "$BPEAplots/v2/vf_fig3_panelB_share.pdf", replace
*graph export "$BPEAplots/v2/vf_fig3_panelB_share.png", replace
*graph export "$BPEAplots/v2/vf_fig3_panelB_share.eps", replace
local call


// combine plots 
cd "$BPEAout/v2_graphs"
local settings xsize(16) ysize(9) graphregion(color(white)) ///
				title("Recent trends in the policy environment", color(black)) ///
				rows(1) xcommon scale(0.8)
				
graph combine "vf_fig3_panelA_share.gph" "vf_fig3_panelB_share.gph" , `settings'

graph save "$BPEAout/v2_graphs/vf_fig3_landscape.gph", replace
graph export "$BPEAplots/vf/pdf/vf_fig3_landscape.pdf", replace
graph export "$BPEAplots/vf/png/vf_fig3_landscape.png", width(4800) height(2700) replace
graph export "$BPEAplots/vf/eps/vf_fig3_landscape.eps", replace
